/**
 * Implements a point (as ordered pair of ints)
 */
import java.util.Arrays;

public class PointXY implements Comparable<PointXY>
{
    private int x, y;
    
    /**
     * Constructs a PointXY at the specified location
     */
    public PointXY(int xc, int yc)
    {
        x = xc;
        y = yc;
    }
    
    /**
     * returns the x coordinate of this point
     @return the x coordinate
     */
    public int getX()
    {
        return x;
    }
    
    /**
     * returns the y coordinate of this point
     @return the y coordinate
     */
    public int getY()
    {
        return y;
    }
    
    /** sets the x coordinate to the supplied value
      * @param xValue the new x coordinate
      */
    public void setX(int xValue)
    {
        x = xValue;
    }
    
    /** sets the y coordinate to the supplied value
      * @param yValue the new y coordinate
      */
    public void setY(int yValue)
    {
        y = yValue;
    }
    
    /** sets the x and y coordinates to the supplied values
      * @param xValue the new x coordinate
      * @param yValue the new y coordinate
      */
    public void setXY(int xValue, int yValue)
    {
        x = xValue;
        y = yValue;
    }
    
    /**
     * Returns the distance between two points
     * @return the distance between this point and one supplied
     */
    public double distance2D(PointXY param)
    {
        double d1 = x - param.x;
        d1 *= d1;
        double d2 = y - param.y;
        d2 *= d2;
        return Math.sqrt(d1 + d2);
    }
    
    public int compareTo(PointXY other)
    {
        /*
        if (x < other.x)
            return -5;
        if (x > other.x)
            return 27;
        if (y < other.y)
            return -5;
        if (y > other.y)
            return 30;
        return 0;  // both x's and both y's must be ==
        */
        
        //or, a little more concisely...
        if (x != other.x)
            return x - other.x;
        return y - other.y;
    }
    
    // whenever you implement compareTo, make sure you implement equals in a consistent manner!
    public boolean equals(Object o)  // the parameter must be Object to override Object equals()
    {
        if (o == null)  // make sure there's an actual Object to compare against!
            return false;
        
        PointXY p = (PointXY)o;  // cast it to the correct type
        return compareTo(p) == 0;  // this is the easiest way to achieve consistency with compareTo!
    }
     
    
    /**
     * Returns a string representing this point
     * @return the string representation
     */
    public String toString()
    {
        return "(" + x + "," + y +")";
    }
    
    public static void main(String[] args)
    {
        PointXY p = new PointXY(2,3);
        PointXY p2 = new PointXY(4,5);
        System.out.println(p + "\t" + p2);
        PointXY otherp = new PointXY(2,3);
        
        if (p.equals(otherp))  // PointXY MUST have an equals method for this to work OK
            System.out.println("equal");
        else
            System.out.println("not equal");
        
        PointXY[] points = new PointXY[10];
        for (int i = 0; i < 10; i++)
            points[i] = new PointXY((int)(Math.random() * 50), (int)(Math.random() * 50));
        System.out.println(Arrays.toString(points));
        Arrays.sort(points);  // In order for this to work, POINTXY's must be Comparable!
        System.out.println(Arrays.toString(points));
    }
}